package gov.va.med.mhv.integration.phr.service;

import java.util.Map;

/**
 * Abstract base class for setting up dependencies.
 * User: Rob Murtha
 */
public abstract class BasePhrService implements PolicyControl {
	protected TrackingService trackingService;
	protected StagingService stagingService;
    protected Map<String, QueryService> queryServiceMap;
    protected ProcessingPolicy policy;
    protected boolean filterDirtyData=true;
    
    public ProcessingPolicy getProcessingPolicy() {
        return this.policy;
    }

    public void setProcessingPolicy(ProcessingPolicy policy) {
        this.policy = policy;
    }

    public TrackingService getTrackingService() {
        return this.trackingService;
    }

    public void setTrackingService(TrackingService trackingService) {
        this.trackingService = trackingService;
    }
    
    public void setStagingService(StagingService stagingService) {
		this.stagingService = stagingService;
	}
    
    protected QueryService getQueryService(String extractType) {
		return queryServiceMap.get(extractType);
	}
    
    public void setQueryServiceMap(Map<String, QueryService> queryServiceMap) {
		this.queryServiceMap = queryServiceMap;
	}

    public boolean isFilterDirtyData() {
        return filterDirtyData;
    }

    public void setFilterDirtyData(boolean filterDirtyData) {
        this.filterDirtyData = filterDirtyData;
    }
}
